<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Payment_request extends CI_Controller
{


    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->library(['ion_auth', 'form_validation', 'upload']);
        $this->load->helper(['url', 'language', 'file']);
        $this->load->model(['payment_request_model', 'delivery_boy_model']);
    }

    public function index()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {
            $this->data['main_page'] = TABLES . 'payment-request';
            $settings = get_settings('system_settings', true);
            $this->data['title'] = 'Return Request | ' . $settings['app_name'];
            $this->data['meta_description'] = ' Return Request  | ' . $settings['app_name'];
            $this->load->view('admin/template', $this->data);
        } else {
            redirect('admin/login', 'refresh');
        }
    }

    public function withdrawal_requests()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_seller() && ($this->ion_auth->seller_status() == 1 || $this->ion_auth->seller_status() == 0)) {
            $this->data['main_page'] = TABLES . 'withdrawal-request';
            $settings = get_settings('system_settings', true);
            $this->data['title'] = 'Seller wallet | ' . $settings['app_name'];
            $this->data['meta_description'] = ' Seller wallet  | ' . $settings['app_name'];
            $this->load->view('seller/template', $this->data);
        } else {
            redirect('seller/login', 'refresh');
        }
    }



    public function update_payment_request()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin()) {
            if (print_msg(!has_permissions('update', 'return_request'), PERMISSION_ERROR_MSG, 'return_request')) {
                return false;
            }
            $this->form_validation->set_rules('payment_request_id', 'id', 'trim|required|numeric|xss_clean');
            $this->form_validation->set_rules('status', 'Status', 'trim|required|numeric|xss_clean');
            $this->form_validation->set_rules('update_remarks', 'Remarks ', 'trim|xss_clean');

            if (!$this->form_validation->run()) {
                sendWebJsonResponse(true, strip_tags(validation_errors()));

            } else {
                $fields = ['payment_request_id', 'status', 'update_remarks', 'id'];

                foreach ($fields as $field) {
                    $payment_request[$field] = $this->input->post($field, true) ?? "";
                }
                $this->payment_request_model->update_payment_request($payment_request);
                sendWebJsonResponse(false, 'Payment request updated successfully');
            }
        } else {
            redirect('admin/login', 'refresh');
        }
    }

    public function view_withdrawal_request_list()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_seller() && ($this->ion_auth->seller_status() == 1 || $this->ion_auth->seller_status() == 0)) {
            $seller_id = $this->session->userdata('user_id');
            return $this->payment_request_model->get_payment_request_list($seller_id);
        } else {
            redirect('seller/login', 'refresh');
        }
    }

    public function send_withdrawal_request()
    {
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_seller() && ($this->ion_auth->seller_status() == 1 || $this->ion_auth->seller_status() == 0)) {
            $this->data['main_page'] = FORMS . 'send-withdrawal-request';
            $settings = get_settings('system_settings', true);
            $this->data['title'] = 'Send Withdrawal Request | ' . $settings['app_name'];
            $this->data['meta_description'] = 'Send Withdrawal Request  | ' . $settings['app_name'];
            $this->data['seller_id'] = $this->session->userdata('user_id');
            $this->load->view('seller/template', $this->data);
        } else {
            redirect('seller/login', 'refresh');
        }
    }

    public function add_withdrawal_request()
    {
        $this->form_validation->set_rules('user_id', 'User Id', 'trim|required|is_natural_no_zero|xss_clean');

        $this->form_validation->set_rules('payment_address', 'Payment Address', 'trim|required|xss_clean');
        $this->form_validation->set_rules('amount', 'Amount', 'trim|required|xss_clean|numeric|greater_than[0]');

        if (!$this->form_validation->run()) {
            sendWebJsonResponse(true, strip_tags(validation_errors()));

        } else {
            $user_id = $this->input->post('user_id', true);
            $payment_address = $this->input->post('payment_address', true);
            $amount = $this->input->post('amount', true);
            $userData = fetch_details('users', ['id' => $user_id], 'balance');
            $seller_id = $this->ion_auth->get_user_id();
            if (!empty($userData)) {
                if ($amount <= $userData[0]['balance']) {
                    $data = [
                        'user_id' => $user_id,
                       
                        'payment_address' => $payment_address,
                        'payment_type' => 'seller',
                        'amount_requested' => $amount,
                    ];

                    if (insert_details($data, 'payment_requests')) {
                        $this->delivery_boy_model->update_balance($amount, $user_id, 'deduct');
                        $userData = fetch_details('users', ['id' => $user_id], 'balance');

                      sendWebJsonResponse(false, 'Withdrawal Request Sent Successfully', [], ['balance' => $userData[0]['balance']]);

                    } else {
                        sendWebJsonResponse(true, 'Cannot sent Withdrawal Request.Please Try again later.');
                    }
                } else {
                    sendWebJsonResponse(true, 'You don\'t have enough balance to sent the withdraw request.');
                }

                // print_r(json_encode($this->response));
            }
        }
    }
}
